/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBHeaderDropDown = Object.create(STBModule.prototype);

STBHeaderDropDown.name = "HeaderDropdown";
STBHeaderDropDown.toggle = function () {

	$(".dropdown-toggle").on("click" , function(e) {
		e.preventDefault();

		var menu = $(this).siblings(".dropdown-menu"),
			parent = $(this).parent();

		if ($("body").hasClass("menu-close")) {
			parent.toggleClass("open");

			if (parent.hasClass("open")) {
				menu.stop(true, true).slideDown(350);
			} else {
				menu.stop(true, true).slideUp(350);
			}
		}
	});

	$("header .navbar .widget-links-megamenu .widget-head").on("click" , function(e) {
		e.preventDefault();

		if ($("body").hasClass("menu-close")) {
			var parent = $(this).parent(),
				menu = parent.find(".widget-body");

			parent.toggleClass("open");

			if (parent.hasClass("open")) {
				menu.stop(true, true).slideDown(350);
			} else {
				menu.stop(true, true).slideUp(350);
			}
		}
	});

	$("header .navbar .widget-head .title").each(function() {
		$(this).html($(this).html() + '<span class="icon-caret"></span>');
	});

}

STBHeaderDropDown.updateCarret = function() {
    try {
        var topMenu = $('.top-menu'),
            navbarDropdowns = topMenu.find('.dropdown');

            if (STBModuleTopintro.pageHasTopIntro()) {

				var windowHeight	= STBHeader.container.height(),
					windowScrollTop = STBHeader.container.scrollTop(),
					dropdownHeight	= (windowHeight / 2);

				if(windowScrollTop > dropdownHeight) {

					topMenu.removeUserClass("zindex");
					navbarDropdowns.removeUserClass('dropup');

				} else {

					topMenu.addUserClass("zindex");
					navbarDropdowns.addUserClass('dropup');
				}
            }

    } catch (e) {
        getStack(0, e);
    }
}

STBHeaderDropDown.updateWidth = function() {

	var drops = $(".navbar-nav > .dropdown > .dropdown-menu > .dropdown-menu-items");

	if (drops.length > 0){
		drops.each(function() {

			var cols = $(this).children().children(".col-lg-auto"),
				parent = $(this).closest(".dropdown-menu"),
				drop = parent.parent(),
				nav = drop.parent(),
				width = 0,
				windowW = document.documentElement.clientWidth || document.body.clientWidth;

				$(this).css("width" , "auto");

			if (cols.length > 0){

				cols.each(function() {
					var col		 = $(this),
						colWidth = Math.ceil(col.outerWidth(true));

					if (windowW > 992) {
						width += colWidth;
					} else {
						width = Math.max(width , colWidth);
					}
				});			

				$(this).css("width" , width);


				if (nav.hasClass("navbar-nav")){
					
					var right = (drop.outerWidth() / 2) - (parent.outerWidth() / 2);
						
					parent.css({
						"left"	: "auto",
						"right"	: right
					});

					var pos = parent.offset();

					if (pos.left < 0 ) {
						right = (right + parseInt(pos.left));
						parent.css({"right" : right });
					} else {

						var left = pos.left + parent.outerWidth();
						if (left > windowW)	{
							right = right - parseInt(windowW - left);
							parent.css({"right" : right });
						}
					}

				}

			}

		});
	}

}

STBHeaderDropDown.runOnReady = function() {
	STBHeaderDropDown.toggle();
	STBHeaderDropDown.updateCarret();


	//attach scroller only if it has top intro
	if (STBModuleTopintro.pageHasTopIntro()) {
		STBHeaderDropDown.runOnScroll = function() {
			STBHeaderDropDown.updateCarret()
		}
	}
}

STBHeaderDropDown.runOnLoad = function() {
	STBHeaderDropDown.updateWidth();
}

STBHeaderDropDown.runOnResize = function() {
	STBHeaderDropDown.updateWidth();
	STBHeaderDropDown.updateCarret();
}


site.registerModule(STBHeaderDropDown);